--  Загруженность операторов 
SELECT 
		op.[Name] [Оператор],
        os.DateTimeStart [Начало последнего статуса], 
        opt.[Name] [Статус],
        CONVERT(VARCHAR(10),cast(os.LenTime as int)/3600)  
                    +':' 
                    + RIGHT('00'+CONVERT(VARCHAR(2),(cast(os.LenTime as int)%3600)/60),2) 
                    +':' 
                    + RIGHT('00'+CONVERT(VARCHAR(2),cast(os.LenTime as int)%60),2) [Время в текущем статусе]
        ,CASE WHEN opt.id = 9 THEN COALESCE((select sub_cls.name from A_TaskManager_CardLunchStates sub_cls WHERE sub_cls.Id = os.icode) , 'Прочие') 
        ELSE ' '
        END [Статус в перерыве]
FROM (
select os.IdOperator, max(os.id) id
    from oktell_cc_temp.dbo.A_Cube_CC_OperatorStates os
	 JOIN oktell.[dbo].[A_CallCenter_UserStateHistory] cch ON 
		cch.[OperatorId] = os.[IdOperator] AND 
		cch.[TimeLeave] IS NULL AND
		cch.[State] = 1 AND
		os.DateTimeStart >= cch.[TimeEnter]
	Group by os.IdOperator
) t
	JOIN oktell_cc_temp.dbo.A_Cube_CC_OperatorStates os ON t.IdOperator = os.IdOperator AND t.id = os.id
    JOIN oktell_cc_temp.dbo.A_Cube_CC_Cat_OperatorStateTypes opt ON opt.Id = os.State
    JOIN oktell_cc_temp..A_Cube_CC_Cat_OperatorInfo op ON os.IdOperator = op.Id
Order by 2 DESC , 1